import os


def load_control_primitives(primitive_path=None):
    primitives = []
    if primitive_path is not None and os.path.exists(primitive_path):
        for primitive in os.listdir(primitive_path):
            if not primitive.endswith(".js"): continue
            f = open(os.path.join(primitive_path, primitive), "r")
            primitives.append(f.read())
        return primitives

    primitive_path = os.path.dirname(__file__)
    for primitive in os.listdir(primitive_path):
        if not primitive.endswith(".js"): continue
        f = open(os.path.join(primitive_path, primitive), "r")
        primitives.append(f.read())
    return primitives
